/**
 * \file: InputChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: CarPlay
 *
 * \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef CARPLAY_INPUTCHANNEL_H
#define CARPLAY_INPUTCHANNEL_H

#include "Common.h"
#include "IInputAdapter.h"

namespace adit { namespace carplay
{

class Session;

class CARPLAY_HIDDEN InputChannel : public IInputReceiver
{
public:
    InputChannel(Session& session);
    ~InputChannel();

    bool Initialize(IConfiguration* config);

private:
    // IInputReceiver implementations
    bool AttachInput(const HIDDevice& device);
    bool DetachInput(const std::string& uuid);
    bool SendInput(const HIDInputReport& report);

    std::list<std::unique_ptr<IInputAdapter>> inputAdapters;
    std::map<std::string, HIDDeviceRef> hidDevices;

    Session& session;
    bool verbose;
};

} } /* namespace adit { namespace carplay */

#endif /* DIPO_INPUTCHANNEL_H */
